﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using VeteransAffairs.Registries.Business;
using VeteransAffairs.Registries.BusinessManager;
using VeteransAffairs.Registries.BusinessManager.TBI;
using System.Text;
using BusinessHelper = VeteransAffairs.Registries.Business.Utilities.Helpers;

public partial class TBI_Instruments_PainOutcomes_Intake : BaseTBIInstrumentPage
{
    #region Variable Declarations

    PatientManager patientManager = new PatientManager();
    InstrumentType instrumentType = new InstrumentType();

    protected int _surveyTypeId = 27; // Database Id for Pain Outcomes Questionnaire VA Long Form - Intake

    SURVEY _survey;   // the root object in the Survey set
    SURVEY_RESULT _surveyResult; // the object representing the actual data in the Survey

    List<STD_QUESTION> QuestionList = new List<STD_QUESTION>();

    #endregion

    /// <summary>
    /// Default Constructor
    /// </summary>
    public TBI_Instruments_PainOutcomes_Intake()
    {
        //Manager Save Notification Event Handler
        patientManager.BOSaveSuccess += manager_BOSaveSuccess;
    }

    #region Protected Methods

    /// <summary>
    /// Page Load method
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void Page_Load(object sender, EventArgs e) {
        TBIServiceTO _tbiServiceTo;

        try {
            _tbiServiceTo = (TBIServiceTO)Session["TBIServiceTO"];
            _tbiInstrumentManager.TbiServiceTo = _tbiServiceTo;

            string instTitle = _tbiInstrumentManager.GetInstrumentByID(_surveyTypeId).Name;

            LabelBreadCrumb.Text = "TBI Instruments > Instrument Associations > " + instTitle;
            LabelInstrumentTitle.Text = instTitle;
            Page.Title = "TBI Instruments - " + instTitle;

            if (_tbiInstrumentManager.TbiServiceTo != null) {
                Label labelUser = (Label)Master.FindControl("LabelCurrentUser");
                labelUser.Text = BusinessHelper.FixStringToPreventXss(_tbiInstrumentManager.TbiServiceTo.UserName);

                LabelPatient.Text = BusinessHelper.FixStringToPreventXss(_tbiInstrumentManager.TbiServiceTo.PatientName);
                LabelSSN.Text = BusinessHelper.FixStringToPreventXss(_tbiInstrumentManager.TbiServiceTo.PatientSnum);
            }
        } catch (Exception ex) {
            //Redirect to message that session is ended and need to log back in from CPRS.
            Exception _tbilogerror = HandleTBIException(ex, "PainOutcomes_Intake.aspx", "100027", "SESSIOENDED");
            Response.Redirect("Warning.aspx?err=2", false);
        }

        if (!IsPostBack) {
            if (instrumentType.Status != null) {
                _tbiInstrumentManager.TbiServiceTo.SelectedInstrumentType = instrumentType;
            }

            string _snum = "";
            if (_tbiInstrumentManager.TbiServiceTo != null) {
                _snum = _tbiInstrumentManager.TbiServiceTo.PatientSnum;
            }

            if (!string.IsNullOrEmpty(_snum))
            {
                string patICN = patientManager.GetPatientICNBySnum(_snum);

                if (!string.IsNullOrEmpty(patICN)) {
                    ViewState["PatientICN"] = patICN;
                    RefreshSurvey(patICN);
                } else {
                    throw new ArgumentException("Patient with this SSN does not exist.");
                }

                if (_survey != null && !_survey.isNew)
                {
                    SetUpSurvey(_survey);
                    //calculateTotal();
                    HideShowQuestions(_survey);
                }
                string referrer = "";
                if (Request.UrlReferrer != null) {
                    referrer = Request.UrlReferrer.PathAndQuery;
                }
                ViewState["referrer"] = referrer;
            }

            //Check if the request is to start a new item 
            //a new item page request is signified when the querystring parameter id equals zero or is not present
            if (_tbiInstrumentManager.TbiServiceTo == null)
            {
                Logging.WriteLogToFile("PainOutcomes_Intake.Page_Load(): WarningRedirect: _tbiInstrumentManager.TbiServiceTo == null");
                //Redirect to message that session is ended and need to log back in from CPRS.
                Response.Redirect("Warning.aspx?err=2");
            } else {
                LabelPatient.Text = BusinessHelper.FixStringToPreventXss(_tbiInstrumentManager.TbiServiceTo.PatientName);
                LabelSSN.Text = BusinessHelper.FixStringToPreventXss(_tbiInstrumentManager.TbiServiceTo.PatientSnum.Trim().Length == 9 ? String.Format("{0:000-00-0000}", int.Parse(_tbiInstrumentManager.TbiServiceTo.PatientSnum)) : _tbiInstrumentManager.TbiServiceTo.PatientSnum);
            }
            lblErrorQ8.Text = "";
            lblErrorQ10.Text = "";
            lblErrorQ17.Text = "";
        }
        QuestionList = GetAllQuestionsForSurvey();

        // Set control values for Diagnosis Question
        ctrlDiagnosis.QuestionText = GetQuestionText("DX");
        ctrlDiagnosis.SurveyTypeCode = HiddenSurveyType.Value;

        //LabelDate1.Text = GetQuestionText("D");
        LabelForQ1.Text = GetQuestionText("1");
        LabelForQ2.Text = GetQuestionText("2");
        LabelForQ3.Text = GetQuestionText("3");
        LabelForQ4.Text = GetQuestionText("4");
        LabelForQ5.Text = GetQuestionText("5");
        LabelForQ6.Text = GetQuestionText("6");
        LabelForQ7.Text = GetQuestionText("7");
        LabelForQ8.Text = GetQuestionText("8");
        LabelForQ9.Text = GetQuestionText("9");
        LabelForQ10.Text = GetQuestionText("10");
        LabelForQ11.Text = GetQuestionText("11");
        LabelForQ12.Text = GetQuestionText("12");
        LabelForQ13.Text = GetQuestionText("13");
        LabelForQ14.Text = GetQuestionText("14");
        LabelForQ15.Text = GetQuestionText("15");
        LabelForQ16.Text = GetQuestionText("16");
        LabelForQ17.Text = GetQuestionText("17");
        LabelForQ18.Text = GetQuestionText("18");
        LabelForQ19.Text = GetQuestionText("19");
        LabelForQ20.Text = GetQuestionText("20");
        LabelForQ21.Text = GetQuestionText("21");
        LabelForQ22.Text = GetQuestionText("22");
        LabelForQ23.Text = GetQuestionText("23");
        LabelForQ24.Text = GetQuestionText("24");
        LabelForQ25.Text = GetQuestionText("25");
        LabelForQ26.Text = GetQuestionText("26");
        LabelForQ27.Text = GetQuestionText("27");
        LabelForQ28.Text = GetQuestionText("28");
        LabelForQ29.Text = GetQuestionText("29");
        LabelForQ30.Text = GetQuestionText("30");
        LabelForQ31.Text = GetQuestionText("31");
        LabelForQ32.Text = GetQuestionText("32");
        LabelForQ33.Text = GetQuestionText("33");
        LabelForQ34.Text = GetQuestionText("34");
        LabelForQ35.Text = GetQuestionText("35");
        LabelForQ36.Text = GetQuestionText("36");
        LabelForQ37.Text = GetQuestionText("37");
        LabelForQ38.Text = GetQuestionText("38");
        LabelForQ39.Text = GetQuestionText("39");
        LabelForQ40.Text = GetQuestionText("40");
        LabelForQ41.Text = GetQuestionText("41");
        LabelForQ42.Text = GetQuestionText("42");
        LabelForQ43.Text = GetQuestionText("43");
        LabelForQ44.Text = GetQuestionText("44");
        LabelForQ45.Text = GetQuestionText("45");
        //dpDate1.MaxDate = DateTime.Now;
        dpDateQ1.MaxDate = DateTime.Now;
    }


    #region Setup CheckBoxLists
    protected void onChbxlstQ8DataBound(object sender, EventArgs e)
    {
        try
        {
            foreach (var sResult in _survey.SURVEY_RESULTs)
            {
                switch (sResult.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER)
                {
                    case "8":
                        if (sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID > -1)
                        {
                            foreach (ListItem item in this.chbxlstQ8.Items)
                            {
                                if (item.Value == sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID.ToString())
                                {
                                    item.Selected = true;
                                    break;
                                }
                            }
                        }
                        break;
                    default:
                        break;
                }
            }
        }
        catch (Exception ex)
        {
        }
    }

    protected void onChbxlstQ10DataBound(object sender, EventArgs e)
    {
        try
        {
            foreach (var sResult in _survey.SURVEY_RESULTs)
            {
                switch (sResult.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER)
                {
                    case "10":
                        if (sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID > -1)
                        {
                            foreach (ListItem item in this.chbxlstQ10.Items)
                            {
                                if (item.Value == sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID.ToString())
                                {
                                    item.Selected = true;
                                    break;
                                }
                            }
                        }
                        break;
                    default:
                        break;
                }
            }
        }
        catch (Exception ex)
        {
        }
    }

    protected void onChbxlstQ17DataBound(object sender, EventArgs e)
    {
        try
        {
            foreach (var sResult in _survey.SURVEY_RESULTs)
            {
                switch (sResult.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER)
                {
                    case "17":
                        if (sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID > -1)
                        {
                            foreach (ListItem item in this.chbxlstQ17.Items)
                            {
                                if (item.Value == sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID.ToString())
                                {
                                    item.Selected = true;
                                    break;
                                }
                            }
                        }
                        break;
                    default:
                        break;
                }
            }
        }
        catch (Exception ex)
        {
        }
    }
    #endregion

    private void HideShowQuestions(SURVEY survey)
    {
        try
        {
            foreach (var sResult in survey.SURVEY_RESULTs)
            {
                switch (sResult.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER)
                {
                    case "36":
                        switch (sResult.STD_QUESTION_CHOICE.CHOICE_NAME.ToUpper())
                        {
                            case "A":
                                plchldrQ37.Visible = false;
                                txtQ37.Text = "";
                                break;
                            case "B":
                                plchldrQ37.Visible = false;
                                txtQ37.Text = "";
                                break;
                            case "C":
                                plchldrQ37.Visible = true;
                                break;
                            default:
                                plchldrQ37.Visible = false;
                                txtQ37.Text = "";
                                break;
                        }
                        break;
                    case "39":
                        switch (sResult.STD_QUESTION_CHOICE.CHOICE_NAME.ToUpper())
                        {
                            case "A": // Yes
                                plchldrQ40_41.Visible = true;
                                plchldrQ42_45.Visible = false;
                                rblQ42.SelectedIndex = -1;
                                txtQ43_1.Text = "0";
                                txtQ43_2.Text = "0";
                                txtQ44_1.Text = "0";
                                txtQ44_2.Text = "0";
                                rblQ45.SelectedIndex = -1;
                                break;
                            case "B": // No
                                plchldrQ40_41.Visible = false;
                                txtQ40_1.Text = "0";
                                txtQ40_2.Text = "0";
                                rblQ41.SelectedIndex = -1;
                                plchldrQ42_45.Visible = true;
                                break;
                            default:
                                plchldrQ40_41.Visible = false;
                                plchldrQ42_45.Visible = false;
                                txtQ40_1.Text = "0";
                                txtQ40_2.Text = "0";
                                rblQ41.SelectedIndex = -1;
                                rblQ42.SelectedIndex = -1;
                                txtQ43_1.Text = "0";
                                txtQ43_2.Text = "0";
                                txtQ44_1.Text = "0";
                                txtQ44_2.Text = "0";
                                rblQ45.SelectedIndex = -1;
                                break;
                        }
                        break;
                    case "42":
                        switch (sResult.STD_QUESTION_CHOICE.CHOICE_NAME.ToUpper())
                        {
                            case "A": // Yes
                                plchldrQ43_45.Visible = true;
                                break;
                            case "B": // No
                                plchldrQ43_45.Visible = false;
                                txtQ43_1.Text = "0";
                                txtQ43_2.Text = "0";
                                txtQ44_1.Text = "0";
                                txtQ44_2.Text = "0";
                                rblQ45.SelectedIndex = -1;
                                break;
                            default:
                                plchldrQ43_45.Visible = false;
                                txtQ43_1.Text = "0";
                                txtQ43_2.Text = "0";
                                txtQ44_1.Text = "0";
                                txtQ44_2.Text = "0";
                                rblQ45.SelectedIndex = -1;
                                break;
                        }
                        break;
                }
            }
        }
        catch (Exception ex) { }
    }


    protected void rblQ36_SelectedIndexChanged(object sender, EventArgs e)
    {
        switch (rblQ36.SelectedIndex)
        {
            case 0:
                plchldrQ37.Visible = false;
                txtQ37.Text = "";
                break;
            case 1:
                plchldrQ37.Visible = false;
                txtQ37.Text = "";
                break;
            case 2:
                plchldrQ37.Visible = true;
                break;
            default:
                plchldrQ37.Visible = false;
                txtQ37.Text = "";
                break;
        }
    }

    protected void rblQ39_SelectedIndexChanged(object sender, EventArgs e)
    {
        switch (rblQ39.SelectedIndex)
        {
            case 0: // Yes
                plchldrQ40_41.Visible = true;
                plchldrQ42_45.Visible = false;
                rblQ42.SelectedIndex = -1;
                txtQ43_1.Text = "0";
                txtQ43_2.Text = "0";
                txtQ44_1.Text = "0";
                txtQ44_2.Text = "0";
                rblQ45.SelectedIndex = -1;
                break;
            case 1: // No
                plchldrQ40_41.Visible = false;
                txtQ40_1.Text = "0";
                txtQ40_2.Text = "0";
                rblQ41.SelectedIndex = -1;
                plchldrQ42_45.Visible = true;
                break;
            default:
                plchldrQ40_41.Visible = false;
                plchldrQ42_45.Visible = false;
                txtQ40_1.Text = "0";
                txtQ40_2.Text = "0";
                rblQ41.SelectedIndex = -1;
                rblQ42.SelectedIndex = -1;
                txtQ43_1.Text = "0";
                txtQ43_2.Text = "0";
                txtQ44_1.Text = "0";
                txtQ44_2.Text = "0";
                rblQ45.SelectedIndex = -1;
                break;
        }
    }
    
    protected void rblQ42_SelectedIndexChanged(object sender, EventArgs e)
    {
        switch (rblQ42.SelectedIndex)
        {
            case 0: // Yes
                plchldrQ43_45.Visible = true;
                break;
            case 1: // No
                plchldrQ43_45.Visible = false;
                txtQ43_1.Text = "0";
                txtQ43_2.Text = "0";
                txtQ44_1.Text = "0";
                txtQ44_2.Text = "0";
                rblQ45.SelectedIndex = -1;
                break;
            default:
                plchldrQ43_45.Visible = false;
                txtQ43_1.Text = "0";
                txtQ43_2.Text = "0";
                txtQ44_1.Text = "0";
                txtQ44_2.Text = "0";
                rblQ45.SelectedIndex = -1;
                break;
        }
    }

    protected override void LoadViewState(object savedState) {
        base.LoadViewState(savedState);
        string surveyXml = (string)ViewState["surveyXml"];
        _survey = SerializerUtil.Deserialize<SURVEY>(surveyXml);
    }

    protected override object SaveViewState() {
        ViewState["surveyXml"] = _survey.Serialize();
        return base.SaveViewState();
    }

    /// <summary>
    /// Returns the Question_Text of the question with the passed Question_Number field
    /// </summary>
    /// <param name="questionId"></param>
    /// <returns></returns>
    protected string GetQuestionText(string questionId) {
        foreach (STD_QUESTION ques in QuestionList) {
            if (ques.QUESTION_NUMBER.ToLower() == questionId.ToLower()) {
                return ques.QUESTION_TEXT;
            }
        }

        return "";
    }

    /// <summary>
    /// Returns the Question_Id of the question with the passed Question_Number field
    /// </summary>
    /// <param name="questionId"></param>
    /// <returns></returns>
    protected int GetQuestionId(string questionNumber) {
        foreach (STD_QUESTION ques in QuestionList) {
            if (ques.QUESTION_NUMBER.ToLower() == questionNumber.ToLower()) {
                return ques.ID;
            }
        }

        return 0;
    }

    /// <summary>
    /// Save Draft button clicked.
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    public void btnSaveSurveyDraft_Click(object sender, EventArgs e) {
        Int32 status = 0;
        SaveFailMessage = "Save Failed. Please press " + btnSaveSurveyDraft.Text + " button again to avoid data loss.";
        SaveCompleteSurvey(ref status);
        SetUpSurvey(_survey);
    }

    /// <summary>
    /// Save and Prepare Note button clicked.
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void btnSubmit_Click(object sender, EventArgs e) {
        Int32 status = 0;
        SaveFailMessage = "Save Failed. Please press " + btnSubmitSurvey.Text + " button again to avoid data loss.";
        SaveCompleteSurvey(ref status);

        if (status > 0) {
            Session["survey"] = _survey;
            Response.Redirect("InstrumentSummaryNote.aspx", false);
        } else {
            SetUpSurvey(_survey); //Follow Save Draft logic 
        }
    }

    /// <summary>
    /// Inactive timer firing.
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void InActiveTimer_Tick(object sender, EventArgs e) {
        Int32 status = 0;
        SaveFailMessage = "Save Failed. Please press " + btnSaveSurveyDraft.Text + " button again to avoid data loss.";

        Page.Validate();

        if (Page.IsValid) {
            SaveCompleteSurvey(ref status);
            //SetUpSurvey(_survey);
            Response.Redirect("PainOutcomes_Intake.aspx", false);
        } else {
            SaveFailMessage = "Auto-Save Validation Failed. Please complete required fields in the survey and press " + btnSaveSurveyDraft.Text + " button again to avoid data loss.";
        }
    }

    /// <summary>
    /// Cancel button clicked.
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void btnCancel_Click(object sender, EventArgs e) {
        ViewState["surveyXml"] = null;
        ViewState["PatientICN"] = null;
        ViewState["referrer"] = null;
        Session.Remove("survey");
        Response.Redirect("Instrument.aspx", false);
        //this.ClientScript.RegisterStartupScript(typeof(Page), "closePage", "<script type='text/javascript'> window.open('','_self','');window.close(); </script>");
    }

    /// <summary>
    /// Hide or Show instructions
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void lnkBtnToggleInstructions_OnClick(object sender, EventArgs e) {
        if (PanelInstructions.Visible) {
            PanelInstructions.Visible = false;
            lnkBtnToggleInstructions.Text = "Click for Instructions";
        } else {
            PanelInstructions.Visible = true;
            lnkBtnToggleInstructions.Text = "Hide Instructions";
        }
    }



    #endregion


    #region Private Methods


    /// <summary>
    /// Calculates number of years and months based on number of months
    /// </summary>
    /// <returns></returns>
    private void getYearsMonths(string strMonths, out int years, out int months)
    {
        int.TryParse(strMonths, out months);
        years = (int)Math.Truncate((double)months / 12);
        months = months - 12 * years;
    }

    /// <summary>
    /// Get all questions for this survey
    /// </summary>
    /// <returns></returns>
    private List<STD_QUESTION> GetAllQuestionsForSurvey() {
        return _tbiInstrumentManager.SelectAllQuestions(_surveyTypeId).ToList();
    }

    /// <summary>
    /// Refresh Survey
    /// </summary>
    /// <param name="patientICN"></param>
    private void RefreshSurvey(string patientICN) {
        var surveys = _tbiInstrumentManager.SelectByPatientICNAndSurveyType(patientICN, _surveyTypeId, true).ToList();

        if (surveys.Count > 0) {
            _survey = surveys.First();
        } else {
            _survey = new SURVEY();
        }

        _survey.SetAsChangeTrackingRoot();
    }

    /// <summary>
    /// Save Complete Survey
    /// </summary>
    /// <param name="status"></param>
    private void SaveCompleteSurvey(ref Int32 status) {
        Page.Validate();
        if ((Page.IsValid) && CheckboxList8Valid() && CheckboxList10Valid() && CheckboxList17Valid())
        {
            lblSurveyError.Text = "";
            //if ((Page.IsValid) && IsQRPT1Valid() && Is28ABValid()) {
            string patientICN = String.Empty;

            status = 0;

            //Retrieve patient's ICN from the session variable
            if (ViewState["PatientICN"] != null)
            {
                patientICN = ViewState["PatientICN"].ToString();
                if (String.IsNullOrEmpty(patientICN.Trim()))
                {
                    Logging.WriteLogToFile("PainOutcomes_Intake.SaveCompletedSurvey(): WarningRedirect: String.IsNullOrEmpty(patientICN.Trim()");
                    //Lost state. Redirect to message that need to log back in from CPRS.
                    Response.Redirect("Warning.aspx?err=2", false);
                }
            }
            else
            {
                Logging.WriteLogToFile("PainOutcomes_Intake.SaveCompletedSurvey(): WarningRedirect: ViewState[PatientICN] != null");
                //Lost state. Redirect to message that need to log back in from CPRS.
                Response.Redirect("Warning.aspx?err=2");
            }

            if (_survey != null)
            {
                if (_survey.isNew)
                {
                    //Ensure that a concurrent session hasn't already inserted a record for this survey
                    var surveys = _tbiInstrumentManager.SelectByPatientICNAndSurveyType(patientICN, _surveyTypeId, true).ToList();

                    if (surveys.Count > 0)
                    {
                        Logging.WriteLogToFile("PainOutcomes_Intake.SaveCompletedSurvey(): WarningRedirect: surveys.Count > 0");
                        //A concurrent session has already inserted a record for this survey and it is not new anymore.
                        Response.Redirect("Warning.aspx?err=9", false);
                    }
                    else
                    {
                        _survey.SURVEY_STATUS = "inprocess";

                        _survey.SetAsInsertOnSubmit();

                        _survey.patient_ICN = patientICN;

                        _survey.STD_SURVEY_TYPE_ID = _surveyTypeId;

                        // TODO: change to datepicker
                        _survey.SURVEY_DATE = DateTime.Today;

                        //Save survey if it's new before adding any responses
                        SuppressSaveMessage = true;
                        _tbiInstrumentManager.Update(_survey);
                        SuppressSaveMessage = false;

                        RefreshSurvey(patientICN);
                    }
                }

                SaveSurvey(ref _survey);

                _survey.SetAsUpdateOnSubmit();
                status = _tbiInstrumentManager.Update(_survey);

                //Fortify errors on this line (this.Master as RegistryInstrumentMaster).SetDirtyFlag(false);
                ((RegistryInstrumentMaster)Master).SetDirtyFlag(false);

                RefreshSurvey(patientICN);
                SuppressSaveMessage = false;
            }
        }
        else
        {
            lblSurveyError.Text = "* Check all required fields. ";
        }
    }

    private bool CheckboxList8Valid()
    {
        bool blnValid = false;
        foreach (ListItem item in chbxlstQ8.Items)
        {
            if (item.Selected)
            {
                blnValid = true;
                break;
            }
        }
        if (!blnValid)
        {
            lblErrorQ8.Text = "* Selection is required.";
        }
        else
        {
            lblErrorQ8.Text = "";
        }
        return blnValid;
    }

    private bool CheckboxList10Valid()
    {
        bool blnValid = false;
        foreach (ListItem item in chbxlstQ10.Items)
        {
            if (item.Selected)
            {
                blnValid = true;
                break;
            }
        }
        if (!blnValid)
        {
            lblErrorQ10.Text = "* Selection is required.";
        }
        else
        {
            lblErrorQ10.Text = "";
        }
        return blnValid;
    }

    private bool CheckboxList17Valid()
    {
        bool blnValid = false;
        foreach (ListItem item in chbxlstQ17.Items)
        {
            if (item.Selected)
            {
                blnValid = true;
                break;
            }
        }
        if (!blnValid)
        {
            lblErrorQ17.Text = "* Selection is required.";
        }
        else
        {
            lblErrorQ17.Text = "";
        }
        return blnValid;
    }



    /// <summary>
    /// Save survey.
    /// </summary>
    /// <param name="survey"></param>
    private void SaveSurvey(ref SURVEY survey)
    {
        //calculateTotal(); // call to re-calculate total score.

        // Ensure lblSurveyError does not contain - ERROR
        if (!lblSurveyError.Text.Contains("ERROR"))
        {
            List<STD_QUESTION> questions = GetAllQuestionsForSurvey();

            //Delete all the survey results from database if there are any.
            SURVEY surveyWithResults = _tbiInstrumentManager.GetSurveyWithAllAnswers(survey.SURVEYS_ID);
            _tbiInstrumentManager.DeleteAllSurveyResults(surveyWithResults);



            // Question DX
            _surveyResult = new SURVEY_RESULT();
            try
            {
                // Add Question DX choice
                _surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(ctrlDiagnosis.GetSelectedId());
                _surveyResult.RESULT_TEXT = ctrlDiagnosis.GetSelectedResultText();
                survey.SURVEY_RESULTs.Add(_surveyResult);
            }
            catch (Exception surveyEx)
            {
                Exception _tbilogerror = HandleTBIException(surveyEx, "PainOutcomes_Intake.aspx", "100027", "SaveSurvey() - Question DX");
            }

            // Question D
            //_surveyResult = new SURVEY_RESULT();
            //if (dpDate1.SelectedDate != null)
            //{
            //    STD_QUESTION questionD = questions.FirstOrDefault(Q => Q.QUESTION_NUMBER == "D");
            //    _surveyResult = new SURVEY_RESULT();
            //    try
            //    {
            //        // Add Question DTE choice
            //        _surveyResult.STD_QUESTION_CHOICE_ID = questionD.STD_QUESTION_CHOICEs.FirstOrDefault().STD_QUESTION_CHOICE_ID;
            //        _surveyResult.RESULT_TEXT = ((DateTime)dpDate1.SelectedDate).ToShortDateString();
            //        survey.SURVEY_RESULTs.Add(_surveyResult);
            //    }
            //    catch (Exception surveyEx)
            //    {
            //        Exception _tbilogerror = HandleTBIException(surveyEx, "PainOutcomes_Intake.aspx", "100027", "SaveSurvey() - Question D");
            //    }
            //}

            // Question Q1
            _surveyResult = new SURVEY_RESULT();
            if (dpDateQ1.SelectedDate != null)
            {
                STD_QUESTION questionQ1 = questions.FirstOrDefault(Q => Q.QUESTION_NUMBER == "1");
                _surveyResult = new SURVEY_RESULT();
                try
                {
                    _surveyResult.STD_QUESTION_CHOICE_ID = questionQ1.STD_QUESTION_CHOICEs.FirstOrDefault().STD_QUESTION_CHOICE_ID;
                    _surveyResult.RESULT_TEXT = ((DateTime)dpDateQ1.SelectedDate).ToShortDateString();
                    survey.SURVEY_RESULTs.Add(_surveyResult);
                }
                catch (Exception surveyEx)
                {
                    Exception _tbilogerror = HandleTBIException(surveyEx, "PainOutcomes_Intake.aspx", "100027", "SaveSurvey() - Question Q1");
                }
            }

            // Question 2
            STD_QUESTION question2 = questions.FirstOrDefault(Q => Q.QUESTION_NUMBER == "2");
            _surveyResult = new SURVEY_RESULT();
            try
            {
                // Add Question 2 choice
                _surveyResult.STD_QUESTION_CHOICE_ID = question2.STD_QUESTION_CHOICEs.FirstOrDefault().STD_QUESTION_CHOICE_ID;
                _surveyResult.RESULT_TEXT = txtQ2.Text;
                survey.SURVEY_RESULTs.Add(_surveyResult);
            }
            catch (Exception surveyEx)
            {
                Exception _tbilogerror = HandleTBIException(surveyEx, "PainOutcomes_Intake.aspx", "100027", "SaveSurvey() - Question 2");
            }

            // Question 3
            _surveyResult = new SURVEY_RESULT();
            try
            {
                // Add Question 3 choice
                _surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(rblQ3.SelectedValue);
                _surveyResult.RESULT_TEXT = rblQ3.SelectedItem.Text;
                survey.SURVEY_RESULTs.Add(_surveyResult);
            }
            catch (Exception surveyEx)
            {
                Exception _tbilogerror = HandleTBIException(surveyEx, "PainOutcomes_Intake.aspx", "100027", "SaveSurvey() - Question 3");
            }

            // Question 4
            _surveyResult = new SURVEY_RESULT();
            try
            {
                // Add Question 4 choice
                _surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(rblQ4.SelectedValue);
                _surveyResult.RESULT_TEXT = rblQ4.SelectedItem.Text;
                survey.SURVEY_RESULTs.Add(_surveyResult);
            }
            catch (Exception surveyEx)
            {
                Exception _tbilogerror = HandleTBIException(surveyEx, "PainOutcomes_Intake.aspx", "100027", "SaveSurvey() - Question 4");
            }

            // Question 5
            _surveyResult = new SURVEY_RESULT();
            try
            {
                // Add Question 5 choice
                _surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(rblQ5.SelectedValue);
                _surveyResult.RESULT_TEXT = rblQ5.SelectedItem.Text;
                survey.SURVEY_RESULTs.Add(_surveyResult);
            }
            catch (Exception surveyEx)
            {
                Exception _tbilogerror = HandleTBIException(surveyEx, "PainOutcomes_Intake.aspx", "100027", "SaveSurvey() - Question 5");
            }

            // Question 6
            _surveyResult = new SURVEY_RESULT();
            try
            {
                // Add Question 6 choice
                _surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(rblQ6.SelectedValue);
                _surveyResult.RESULT_TEXT = rblQ6.SelectedItem.Text;
                survey.SURVEY_RESULTs.Add(_surveyResult);
            }
            catch (Exception surveyEx)
            {
                Exception _tbilogerror = HandleTBIException(surveyEx, "PainOutcomes_Intake.aspx", "100027", "SaveSurvey() - Question 6");
            }

            // Question 7
            STD_QUESTION question7 = questions.FirstOrDefault(Q => Q.QUESTION_NUMBER == "7");
            _surveyResult = new SURVEY_RESULT();
            try
            {
                // Add Question 7 choice
                _surveyResult.STD_QUESTION_CHOICE_ID = question7.STD_QUESTION_CHOICEs.FirstOrDefault().STD_QUESTION_CHOICE_ID;
                _surveyResult.RESULT_TEXT = txtQ7.Text;
                survey.SURVEY_RESULTs.Add(_surveyResult);
            }
            catch (Exception surveyEx)
            {
                Exception _tbilogerror = HandleTBIException(surveyEx, "PainOutcomes_Intake.aspx", "100027", "SaveSurvey() - Question 7");
            }

            // Question 8
            try
            {
                // Add Question 8 choice(s)
                foreach (ListItem item in chbxlstQ8.Items)
                {
                    if (item.Selected)
                    {
                        _surveyResult = new SURVEY_RESULT();
                        _surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(item.Value);
                        _surveyResult.RESULT_TEXT = item.Text;
                        survey.SURVEY_RESULTs.Add(_surveyResult);
                    }
                }
            }
            catch (Exception surveyEx)
            {
                Exception _tbilogerror = HandleTBIException(surveyEx, "PainOutcomes_Intake.aspx", "100027", "SaveSurvey() - Question 8");
            }

            // Question 9
            _surveyResult = new SURVEY_RESULT();
            try
            {
                // Add Question 9 choice
                _surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(rblQ9.SelectedValue);
                _surveyResult.RESULT_TEXT = rblQ9.SelectedItem.Text;
                survey.SURVEY_RESULTs.Add(_surveyResult);
            }
            catch (Exception surveyEx)
            {
                Exception _tbilogerror = HandleTBIException(surveyEx, "PainOutcomes_Intake.aspx", "100027", "SaveSurvey() - Question 9");
            }

            // Question 10
            try
            {
                // Add Question 10 choice(s)
                foreach (ListItem item in chbxlstQ10.Items)
                {
                    if (item.Selected)
                    {
                        _surveyResult = new SURVEY_RESULT();
                        _surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(item.Value);
                        _surveyResult.RESULT_TEXT = item.Text;
                        survey.SURVEY_RESULTs.Add(_surveyResult);
                    }
                }
            }
            catch (Exception surveyEx)
            {
                Exception _tbilogerror = HandleTBIException(surveyEx, "PainOutcomes_Intake.aspx", "100027", "SaveSurvey() - Question 10");
            }

            // Question 11
            _surveyResult = new SURVEY_RESULT();
            try
            {
                // Add Question 11 choice
                _surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(rblQ11.SelectedValue);
                _surveyResult.RESULT_TEXT = rblQ11.SelectedItem.Text;
                survey.SURVEY_RESULTs.Add(_surveyResult);
            }
            catch (Exception surveyEx)
            {
                Exception _tbilogerror = HandleTBIException(surveyEx, "PainOutcomes_Intake.aspx", "100027", "SaveSurvey() - Question 11");
            }

            // Question 12
            _surveyResult = new SURVEY_RESULT();

            try
            {
                // Add Question 12 choice
                _surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(rblQ12.SelectedValue);
                _surveyResult.RESULT_TEXT = rblQ12.SelectedItem.Text;
                survey.SURVEY_RESULTs.Add(_surveyResult);
            }
            catch (Exception surveyEx)
            {
                Exception _tbilogerror = HandleTBIException(surveyEx, "PainOutcomes_Intake.aspx", "100027", "SaveSurvey() - Question 12");
            }

            // Question 13
            _surveyResult = new SURVEY_RESULT();
            try
            {
                // Add Question 13 choice
                _surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(rblQ13.SelectedValue);
                _surveyResult.RESULT_TEXT = rblQ13.SelectedItem.Text;
                survey.SURVEY_RESULTs.Add(_surveyResult);
            }
            catch (Exception surveyEx)
            {
                Exception _tbilogerror = HandleTBIException(surveyEx, "PainOutcomes_Intake.aspx", "100027", "SaveSurvey() - Question 13");
            }

            // Question 14
            STD_QUESTION question14 = questions.FirstOrDefault(Q => Q.QUESTION_NUMBER == "14");
            _surveyResult = new SURVEY_RESULT();
            try
            {
                // Add Question 14 choice
                _surveyResult.STD_QUESTION_CHOICE_ID = question14.STD_QUESTION_CHOICEs.FirstOrDefault().STD_QUESTION_CHOICE_ID;
                int years = 0;
                int months = 0;
                int.TryParse(txtQ14_1.Text, out years);
                int.TryParse(txtQ14_2.Text, out months);
                months = years*12 + months;
                _surveyResult.RESULT_TEXT = months.ToString();
                survey.SURVEY_RESULTs.Add(_surveyResult);
            }
            catch (Exception surveyEx)
            {
                Exception _tbilogerror = HandleTBIException(surveyEx, "PainOutcomes_Intake.aspx", "100027", "SaveSurvey() - Question 14");
            }

            // Question 15
            STD_QUESTION question15 = questions.FirstOrDefault(Q => Q.QUESTION_NUMBER == "15");
            _surveyResult = new SURVEY_RESULT();
            try
            {
                // Add Question 15 choice
                _surveyResult.STD_QUESTION_CHOICE_ID = question15.STD_QUESTION_CHOICEs.FirstOrDefault().STD_QUESTION_CHOICE_ID;
                _surveyResult.RESULT_TEXT = txtQ15.Text;
                survey.SURVEY_RESULTs.Add(_surveyResult);
            }
            catch (Exception surveyEx)
            {
                Exception _tbilogerror = HandleTBIException(surveyEx, "PainOutcomes_Intake.aspx", "100027", "SaveSurvey() - Question 15");
            }

            // Question 16
            STD_QUESTION question16 = questions.FirstOrDefault(Q => Q.QUESTION_NUMBER == "16");
            _surveyResult = new SURVEY_RESULT();
            try
            {
                // Add Question 16 choice
                _surveyResult.STD_QUESTION_CHOICE_ID = question16.STD_QUESTION_CHOICEs.FirstOrDefault().STD_QUESTION_CHOICE_ID;
                _surveyResult.RESULT_TEXT = txtQ16.Text;
                survey.SURVEY_RESULTs.Add(_surveyResult);
            }
            catch (Exception surveyEx)
            {
                Exception _tbilogerror = HandleTBIException(surveyEx, "PainOutcomes_Intake.aspx", "100027", "SaveSurvey() - Question 16");
            }

            // Question 17
            try
            {
                // Add Question 17 choice(s)
                foreach (ListItem item in chbxlstQ17.Items)
                {
                    if (item.Selected)
                    {
                        _surveyResult = new SURVEY_RESULT();
                        _surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(item.Value);
                        _surveyResult.RESULT_TEXT = item.Text;
                        survey.SURVEY_RESULTs.Add(_surveyResult);
                    }
                }
            }
            catch (Exception surveyEx)
            {
                Exception _tbilogerror = HandleTBIException(surveyEx, "PainOutcomes_Intake.aspx", "100027", "SaveSurvey() - Question 17");
            }

            // Question 18
            _surveyResult = new SURVEY_RESULT();
            try
            {
                // Add Question 18 choice
                _surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(rblQ18.SelectedValue);
                _surveyResult.RESULT_TEXT = rblQ18.SelectedItem.Text;
                survey.SURVEY_RESULTs.Add(_surveyResult);
            }
            catch (Exception surveyEx)
            {
                Exception _tbilogerror = HandleTBIException(surveyEx, "PainOutcomes_Intake.aspx", "100027", "SaveSurvey() - Question 18");
            }

            // Question 19
            _surveyResult = new SURVEY_RESULT();
            try
            {
                // Add Question 19 choice
                _surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(rblQ19.SelectedValue);
                _surveyResult.RESULT_TEXT = rblQ19.SelectedItem.Text;
                survey.SURVEY_RESULTs.Add(_surveyResult);
            }
            catch (Exception surveyEx)
            {
                Exception _tbilogerror = HandleTBIException(surveyEx, "PainOutcomes_Intake.aspx", "100027", "SaveSurvey() - Question 19");
            }

            // Question 20
            _surveyResult = new SURVEY_RESULT();
            try
            {
                // Add Question 20 choice
                _surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(rblQ20.SelectedValue);
                _surveyResult.RESULT_TEXT = rblQ20.SelectedItem.Text;
                survey.SURVEY_RESULTs.Add(_surveyResult);
            }
            catch (Exception surveyEx)
            {
                Exception _tbilogerror = HandleTBIException(surveyEx, "PainOutcomes_Intake.aspx", "100027", "SaveSurvey() - Question 20");
            }

            // Question 21
            _surveyResult = new SURVEY_RESULT();
            try
            {
                // Add Question 21 choice
                _surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(rblQ21.SelectedValue);
                _surveyResult.RESULT_TEXT = rblQ21.SelectedItem.Text;
                survey.SURVEY_RESULTs.Add(_surveyResult);
            }
            catch (Exception surveyEx)
            {
                Exception _tbilogerror = HandleTBIException(surveyEx, "PainOutcomes_Intake.aspx", "100027", "SaveSurvey() - Question 21");
            }

            // Question 22
            _surveyResult = new SURVEY_RESULT();
            try
            {
                // Add Question 22 choice
                _surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(rblQ22.SelectedValue);
                _surveyResult.RESULT_TEXT = rblQ22.SelectedItem.Text;
                survey.SURVEY_RESULTs.Add(_surveyResult);
            }
            catch (Exception surveyEx)
            {
                Exception _tbilogerror = HandleTBIException(surveyEx, "PainOutcomes_Intake.aspx", "100027", "SaveSurvey() - Question 22");
            }

            // Question 23
            _surveyResult = new SURVEY_RESULT();
            try
            {
                // Add Question 23 choice
                _surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(rblQ23.SelectedValue);
                _surveyResult.RESULT_TEXT = rblQ23.SelectedItem.Text;
                survey.SURVEY_RESULTs.Add(_surveyResult);
            }
            catch (Exception surveyEx)
            {
                Exception _tbilogerror = HandleTBIException(surveyEx, "PainOutcomes_Intake.aspx", "100027", "SaveSurvey() - Question 23");
            }

            // Question 24
            _surveyResult = new SURVEY_RESULT();
            try
            {
                // Add Question 24 choice
                _surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(rblQ24.SelectedValue);
                _surveyResult.RESULT_TEXT = rblQ24.SelectedItem.Text;
                survey.SURVEY_RESULTs.Add(_surveyResult);
            }
            catch (Exception surveyEx)
            {
                Exception _tbilogerror = HandleTBIException(surveyEx, "PainOutcomes_Intake.aspx", "100027", "SaveSurvey() - Question 24");
            }

            // Question 25
            _surveyResult = new SURVEY_RESULT();
            try
            {
                // Add Question 25 choice
                _surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(rblQ25.SelectedValue);
                _surveyResult.RESULT_TEXT = rblQ25.SelectedItem.Text;
                survey.SURVEY_RESULTs.Add(_surveyResult);
            }
            catch (Exception surveyEx)
            {
                Exception _tbilogerror = HandleTBIException(surveyEx, "PainOutcomes_Intake.aspx", "100027", "SaveSurvey() - Question 25");
            }

            // Question 26
            _surveyResult = new SURVEY_RESULT();
            try
            {
                // Add Question 26 choice
                _surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(rblQ26.SelectedValue);
                _surveyResult.RESULT_TEXT = rblQ26.SelectedItem.Text;
                survey.SURVEY_RESULTs.Add(_surveyResult);
            }
            catch (Exception surveyEx)
            {
                Exception _tbilogerror = HandleTBIException(surveyEx, "PainOutcomes_Intake.aspx", "100027", "SaveSurvey() - Question 26");
            }

            // Question 27
            _surveyResult = new SURVEY_RESULT();
            try
            {
                // Add Question 27 choice
                _surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(rblQ27.SelectedValue);
                _surveyResult.RESULT_TEXT = rblQ27.SelectedItem.Text;
                survey.SURVEY_RESULTs.Add(_surveyResult);
            }
            catch (Exception surveyEx)
            {
                Exception _tbilogerror = HandleTBIException(surveyEx, "PainOutcomes_Intake.aspx", "100027", "SaveSurvey() - Question 27");
            }

            // Question 28
            _surveyResult = new SURVEY_RESULT();
            try
            {
                // Add Question 28 choice
                _surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(rblQ28.SelectedValue);
                _surveyResult.RESULT_TEXT = rblQ28.SelectedItem.Text;
                survey.SURVEY_RESULTs.Add(_surveyResult);
            }
            catch (Exception surveyEx)
            {
                Exception _tbilogerror = HandleTBIException(surveyEx, "PainOutcomes_Intake.aspx", "100027", "SaveSurvey() - Question 28");
            }


            // Question 29
            _surveyResult = new SURVEY_RESULT();
            try
            {
                // Add Question 29 choice
                _surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(rblQ29.SelectedValue);
                _surveyResult.RESULT_TEXT = rblQ29.SelectedItem.Text;
                survey.SURVEY_RESULTs.Add(_surveyResult);
            }
            catch (Exception surveyEx)
            {
                Exception _tbilogerror = HandleTBIException(surveyEx, "PainOutcomes_Intake.aspx", "100027", "SaveSurvey() - Question 29");
            }

            // Question 30
            _surveyResult = new SURVEY_RESULT();
            try
            {
                // Add Question 30 choice
                _surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(rblQ30.SelectedValue);
                _surveyResult.RESULT_TEXT = rblQ30.SelectedItem.Text;
                survey.SURVEY_RESULTs.Add(_surveyResult);
            }
            catch (Exception surveyEx)
            {
                Exception _tbilogerror = HandleTBIException(surveyEx, "PainOutcomes_Intake.aspx", "100027", "SaveSurvey() - Question 30");
            }

            // Question 31
            _surveyResult = new SURVEY_RESULT();
            try
            {
                // Add Question 31 choice
                _surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(rblQ31.SelectedValue);
                _surveyResult.RESULT_TEXT = rblQ31.SelectedItem.Text;
                survey.SURVEY_RESULTs.Add(_surveyResult);
            }
            catch (Exception surveyEx)
            {
                Exception _tbilogerror = HandleTBIException(surveyEx, "PainOutcomes_Intake.aspx", "100027", "SaveSurvey() - Question 31");
            }

            // Question 32
            _surveyResult = new SURVEY_RESULT();
            try
            {
                // Add Question 32 choice
                _surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(rblQ32.SelectedValue);
                _surveyResult.RESULT_TEXT = rblQ32.SelectedItem.Text;
                survey.SURVEY_RESULTs.Add(_surveyResult);
            }
            catch (Exception surveyEx)
            {
                Exception _tbilogerror = HandleTBIException(surveyEx, "PainOutcomes_Intake.aspx", "100027", "SaveSurvey() - Question 32");
            }

            // Question 33
            _surveyResult = new SURVEY_RESULT();
            try
            {
                // Add Question 33 choice
                _surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(rblQ33.SelectedValue);
                _surveyResult.RESULT_TEXT = rblQ33.SelectedItem.Text;
                survey.SURVEY_RESULTs.Add(_surveyResult);
            }
            catch (Exception surveyEx)
            {
                Exception _tbilogerror = HandleTBIException(surveyEx, "PainOutcomes_Intake.aspx", "100027", "SaveSurvey() - Question 33");
            }

            // Question 34
            _surveyResult = new SURVEY_RESULT();
            try
            {
                // Add Question 34 choice
                _surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(rblQ34.SelectedValue);
                _surveyResult.RESULT_TEXT = rblQ34.SelectedItem.Text;
                survey.SURVEY_RESULTs.Add(_surveyResult);
            }
            catch (Exception surveyEx)
            {
                Exception _tbilogerror = HandleTBIException(surveyEx, "PainOutcomes_Intake.aspx", "100027", "SaveSurvey() - Question 34");
            }

            // Question 35
            _surveyResult = new SURVEY_RESULT();
            try
            {
                // Add Question 35 choice
                _surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(rblQ35.SelectedValue);
                _surveyResult.RESULT_TEXT = rblQ35.SelectedItem.Text;
                survey.SURVEY_RESULTs.Add(_surveyResult);
            }
            catch (Exception surveyEx)
            {
                Exception _tbilogerror = HandleTBIException(surveyEx, "PainOutcomes_Intake.aspx", "100027", "SaveSurvey() - Question 35");
            }

            // Question 36
            _surveyResult = new SURVEY_RESULT();
            try
            {
                // Add Question 36 choice
                _surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(rblQ36.SelectedValue);
                _surveyResult.RESULT_TEXT = rblQ36.SelectedItem.Text;
                survey.SURVEY_RESULTs.Add(_surveyResult);
            }
            catch (Exception surveyEx)
            {
                Exception _tbilogerror = HandleTBIException(surveyEx, "PainOutcomes_Intake.aspx", "100027", "SaveSurvey() - Question 36");
            }

            if (rblQ36.SelectedIndex == 2) // C = "Service Connected"
            {
                // Question 37
                STD_QUESTION question37 = questions.FirstOrDefault(Q => Q.QUESTION_NUMBER == "37");
                _surveyResult = new SURVEY_RESULT();
                try
                {
                    // Add Question 37 choice
                    _surveyResult.STD_QUESTION_CHOICE_ID = question37.STD_QUESTION_CHOICEs.FirstOrDefault().STD_QUESTION_CHOICE_ID;
                    _surveyResult.RESULT_TEXT = txtQ37.Text;
                    survey.SURVEY_RESULTs.Add(_surveyResult);
                }
                catch (Exception surveyEx)
                {
                    Exception _tbilogerror = HandleTBIException(surveyEx, "PainOutcomes_Intake.aspx", "100027", "SaveSurvey() - Question 37");
                }
            }


            // Question 38
            _surveyResult = new SURVEY_RESULT();
            try
            {
                // Add Question 38 choice
                _surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(rblQ38.SelectedValue);
                _surveyResult.RESULT_TEXT = rblQ38.SelectedItem.Text;
                survey.SURVEY_RESULTs.Add(_surveyResult);
            }
            catch (Exception surveyEx)
            {
                Exception _tbilogerror = HandleTBIException(surveyEx, "PainOutcomes_Intake.aspx", "100027", "SaveSurvey() - Question 38");
            }

            // Question 39
            _surveyResult = new SURVEY_RESULT();
            try
            {
                // Add Question 39 choice
                _surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(rblQ39.SelectedValue);
                _surveyResult.RESULT_TEXT = rblQ39.SelectedItem.Text;
                survey.SURVEY_RESULTs.Add(_surveyResult);
            }
            catch (Exception surveyEx)
            {
                Exception _tbilogerror = HandleTBIException(surveyEx, "PainOutcomes_Intake.aspx", "100027", "SaveSurvey() - Question 39");
            }

            if (rblQ39.SelectedIndex == 0) // YES
            {
                // Question 40
                STD_QUESTION question40 = questions.FirstOrDefault(Q => Q.QUESTION_NUMBER == "40");
                _surveyResult = new SURVEY_RESULT();
                try
                {
                    // Add Question 40 choice
                    _surveyResult.STD_QUESTION_CHOICE_ID = question40.STD_QUESTION_CHOICEs.FirstOrDefault().STD_QUESTION_CHOICE_ID;
                    int years = 0;
                    int months = 0;
                    int.TryParse(txtQ40_1.Text, out years);
                    int.TryParse(txtQ40_2.Text, out months);
                    months = years * 12 + months;
                    _surveyResult.RESULT_TEXT = months.ToString();
                    survey.SURVEY_RESULTs.Add(_surveyResult);
                }
                catch (Exception surveyEx)
                {
                    Exception _tbilogerror = HandleTBIException(surveyEx, "PainOutcomes_Intake.aspx", "100027", "SaveSurvey() - Question 40");
                }

                // Question 41
                _surveyResult = new SURVEY_RESULT();
                try
                {
                    // Add Question 41 choice
                    _surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(rblQ41.SelectedValue);
                    _surveyResult.RESULT_TEXT = rblQ41.SelectedItem.Text;
                    survey.SURVEY_RESULTs.Add(_surveyResult);
                }
                catch (Exception surveyEx)
                {
                    Exception _tbilogerror = HandleTBIException(surveyEx, "PainOutcomes_Intake.aspx", "100027", "SaveSurvey() - Question 41");
                }
            }
            else
            {
                // Question 42
                _surveyResult = new SURVEY_RESULT();
                try
                {
                    // Add Question 42 choice
                    _surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(rblQ42.SelectedValue);
                    _surveyResult.RESULT_TEXT = rblQ42.SelectedItem.Text;
                    survey.SURVEY_RESULTs.Add(_surveyResult);
                }
                catch (Exception surveyEx)
                {
                    Exception _tbilogerror = HandleTBIException(surveyEx, "PainOutcomes_Intake.aspx", "100027", "SaveSurvey() - Question 42");
                }

                if (rblQ42.SelectedIndex == 0) //YES
                {
                    // Question 43
                    STD_QUESTION question43 = questions.FirstOrDefault(Q => Q.QUESTION_NUMBER == "43");
                    _surveyResult = new SURVEY_RESULT();
                    try
                    {
                        // Add Question 43 choice
                        _surveyResult.STD_QUESTION_CHOICE_ID = question43.STD_QUESTION_CHOICEs.FirstOrDefault().STD_QUESTION_CHOICE_ID;
                        int years = 0;
                        int months = 0;
                        int.TryParse(txtQ43_1.Text, out years);
                        int.TryParse(txtQ43_2.Text, out months);
                        months = years * 12 + months;
                        _surveyResult.RESULT_TEXT = months.ToString();
                        survey.SURVEY_RESULTs.Add(_surveyResult);
                    }
                    catch (Exception surveyEx)
                    {
                        Exception _tbilogerror = HandleTBIException(surveyEx, "PainOutcomes_Intake.aspx", "100027", "SaveSurvey() - Question 43");
                    }

                    // Question 44
                    STD_QUESTION question44 = questions.FirstOrDefault(Q => Q.QUESTION_NUMBER == "44");
                    _surveyResult = new SURVEY_RESULT();
                    try
                    {
                        // Add Question 44 choice
                        _surveyResult.STD_QUESTION_CHOICE_ID = question44.STD_QUESTION_CHOICEs.FirstOrDefault().STD_QUESTION_CHOICE_ID;
                        int years = 0;
                        int months = 0;
                        int.TryParse(txtQ44_1.Text, out years);
                        int.TryParse(txtQ44_2.Text, out months);
                        months = years * 12 + months;
                        _surveyResult.RESULT_TEXT = months.ToString();
                        survey.SURVEY_RESULTs.Add(_surveyResult);
                    }
                    catch (Exception surveyEx)
                    {
                        Exception _tbilogerror = HandleTBIException(surveyEx, "PainOutcomes_Intake.aspx", "100027", "SaveSurvey() - Question 44");
                    }

                    // Question 45
                    _surveyResult = new SURVEY_RESULT();
                    try
                    {
                        // Add Question 45 choice
                        _surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(rblQ45.SelectedValue);
                        _surveyResult.RESULT_TEXT = rblQ45.SelectedItem.Text;
                        survey.SURVEY_RESULTs.Add(_surveyResult);
                    }
                    catch (Exception surveyEx)
                    {
                        Exception _tbilogerror = HandleTBIException(surveyEx, "PainOutcomes_Intake.aspx", "100027", "SaveSurvey() - Question 45");
                    }
                }
            }

        }
        else
        {
            // do not save ... 
        }
    }// END SaveSurvey




    /// <summary>
    /// Initialize/setup controls
    /// </summary>
    /// <param name="survey"></param>
    private void SetUpSurvey(SURVEY survey) {
        int months = 0;
        int years = 0;
        try {
            foreach (var sResult in survey.SURVEY_RESULTs) {
                switch (sResult.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER) {
                    case "DX":
                        if (sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID > -1)
                        {
                            ctrlDiagnosis.SelectedChoiceId = sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID.ToString();

                            if (sResult.STD_QUESTION_CHOICE.CHOICE_TEXT.ToLower().Contains("other"))
                            {
                                ctrlDiagnosis.SetOtherDescriptionText(sResult.RESULT_TEXT);
                            }
                        }
                        else
                        {
                            ctrlDiagnosis.SelectedChoiceId = null;
                        }
                        break;
                    //case "D":
                    //    if (!String.IsNullOrEmpty(sResult.RESULT_TEXT)) {
                    //        DateTime temp;
                    //        if (DateTime.TryParse(sResult.RESULT_TEXT, out temp)) {
                    //            dpDate1.SelectedDate = temp;
                    //        }
                    //    }
                    //    break;
                    case "1":
                        if (!String.IsNullOrEmpty(sResult.RESULT_TEXT))
                        {
                            DateTime temp;
                            if (DateTime.TryParse(sResult.RESULT_TEXT, out temp))
                            {
                                dpDateQ1.SelectedDate = temp;
                            }
                        }
                        break;
                    case "2":
                        txtQ2.Text = sResult.RESULT_TEXT;
                        break;
                    case "3":
                        if (sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID > -1)
                        {
                            rblQ3.SelectedValue = sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID.ToString();
                        }
                        else
                        {
                            rblQ3.SelectedIndex = -1;
                        }
                        break;
                    case "4":
                        if (sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID > -1)
                        {
                            rblQ4.SelectedValue = sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID.ToString();
                        }
                        else
                        {
                            rblQ4.SelectedIndex = -1;
                        }
                        break;
                    case "5":
                        if (sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID > -1)
                        {
                            rblQ5.SelectedValue = sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID.ToString();
                        }
                        else
                        {
                            rblQ5.SelectedIndex = -1;
                        }
                        break;
                    case "6":
                        if (sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID > -1)
                        {
                            rblQ6.SelectedValue = sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID.ToString();
                        }
                        else
                        {
                            rblQ6.SelectedIndex = -1;
                        }
                        break;
                    case "7":
                        txtQ7.Text = sResult.RESULT_TEXT;
                        break;
                    case "8":
                        //if (sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID > -1)
                        //{
                        foreach (ListItem item in this.chbxlstQ8.Items)
                        {
                            if (item.Value == sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID.ToString())
                            {
                                item.Selected = true;
                                break;
                            }
                        }
                        //}
                        //else
                        //{
                        //    chbxlstQ8.SelectedIndex = -1;
                        //}
                        break;
                    case "9":
                        if (sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID > -1)
                        {
                            rblQ9.SelectedValue = sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID.ToString();
                        }
                        else
                        {
                            rblQ9.SelectedIndex = -1;
                        }
                        break;
                    case "10":
                        foreach (ListItem item in this.chbxlstQ10.Items)
                        {
                            if (item.Value == sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID.ToString())
                            {
                                item.Selected = true;
                                break;
                            }
                        }
                        break;
                    case "11":
                        if (sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID > -1)
                        {
                            rblQ11.SelectedValue = sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID.ToString();
                        }
                        else
                        {
                            rblQ11.SelectedIndex = -1;
                        }
                        break;
                    case "12":
                        if (sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID > -1)
                        {
                            rblQ12.SelectedValue = sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID.ToString();
                        }
                        else
                        {
                            rblQ12.SelectedIndex = -1;
                        }
                        break;
                    case "13":
                        if (sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID > -1)
                        {
                            rblQ13.SelectedValue = sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID.ToString();
                        }
                        else
                        {
                            rblQ13.SelectedIndex = -1;
                        }
                        break;
                    case "14":
                        months = 0;
                        years = 0;
                        getYearsMonths(sResult.RESULT_TEXT, out years, out months);
                        txtQ14_1.Text = years.ToString();
                        txtQ14_2.Text = months.ToString();
                        break;
                    case "15":
                        txtQ15.Text = sResult.RESULT_TEXT;
                        break;
                    case "16":
                        txtQ16.Text = sResult.RESULT_TEXT;
                        break;
                    case "17":
                        foreach (ListItem item in this.chbxlstQ17.Items)
                        {
                            if (item.Value == sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID.ToString())
                            {
                                item.Selected = true;
                                break;
                            }
                        }
                        break;
                    case "18":
                        if (sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID > -1)
                        {
                            rblQ18.SelectedValue = sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID.ToString();
                        }
                        else
                        {
                            rblQ18.SelectedIndex = -1;
                        }
                        break;
                    case "19":
                        if (sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID > -1)
                        {
                            rblQ19.SelectedValue = sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID.ToString();
                        }
                        else
                        {
                            rblQ19.SelectedIndex = -1;
                        }
                        break;
                    case "20":
                        if (sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID > -1)
                        {
                            rblQ20.SelectedValue = sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID.ToString();
                        }
                        else
                        {
                            rblQ20.SelectedIndex = -1;
                        }
                        break;
                    case "21":
                        if (sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID > -1)
                        {
                            rblQ21.SelectedValue = sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID.ToString();
                        }
                        else
                        {
                            rblQ21.SelectedIndex = -1;
                        }
                        break;
                    case "22":
                        if (sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID > -1)
                        {
                            rblQ22.SelectedValue = sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID.ToString();
                        }
                        else
                        {
                            rblQ22.SelectedIndex = -1;
                        }
                        break;
                    case "23":
                        if (sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID > -1)
                        {
                            rblQ23.SelectedValue = sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID.ToString();
                        }
                        else
                        {
                            rblQ23.SelectedIndex = -1;
                        }
                        break;
                    case "24":
                        if (sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID > -1)
                        {
                            rblQ24.SelectedValue = sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID.ToString();
                        }
                        else
                        {
                            rblQ24.SelectedIndex = -1;
                        }
                        break;
                    case "25":
                        if (sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID > -1)
                        {
                            rblQ25.SelectedValue = sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID.ToString();
                        }
                        else
                        {
                            rblQ25.SelectedIndex = -1;
                        }
                        break;
                    case "26":
                        if (sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID > -1)
                        {
                            rblQ26.SelectedValue = sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID.ToString();
                        }
                        else
                        {
                            rblQ26.SelectedIndex = -1;
                        }
                        break;
                    case "27":
                        if (sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID > -1)
                        {
                            rblQ27.SelectedValue = sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID.ToString();
                        }
                        else
                        {
                            rblQ27.SelectedIndex = -1;
                        }
                        break;
                    case "28":
                        if (sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID > -1)  
                        {
                            rblQ28.SelectedValue = sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID.ToString();
                        }
                        else
                        {
                            rblQ28.SelectedIndex = -1;
                        }
                        break;
                    case "29":
                        if (sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID > -1)
                        {
                            rblQ29.SelectedValue = sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID.ToString();
                        }
                        else
                        {
                            rblQ29.SelectedIndex = -1;
                        }
                        break;
                    case "30":
                        if (sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID > -1)
                        {
                            rblQ30.SelectedValue = sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID.ToString();
                        }
                        else
                        {
                            rblQ30.SelectedIndex = -1;
                        }
                        break;
                    case "31":
                        if (sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID > -1)
                        {
                            rblQ31.SelectedValue = sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID.ToString();
                        }
                        else
                        {
                            rblQ31.SelectedIndex = -1;
                        }
                        break;
                    case "32":
                        if (sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID > -1)
                        {
                            rblQ32.SelectedValue = sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID.ToString();
                        }
                        else
                        {
                            rblQ32.SelectedIndex = -1;
                        }
                        break;
                    case "33":
                        if (sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID > -1)
                        {
                            rblQ33.SelectedValue = sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID.ToString();
                        }
                        else
                        {
                            rblQ33.SelectedIndex = -1;
                        }
                        break;
                    case "34":
                        if (sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID > -1)
                        {
                            rblQ34.SelectedValue = sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID.ToString();
                        }
                        else
                        {
                            rblQ34.SelectedIndex = -1;
                        }
                        break;
                    case "35":
                        if (sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID > -1)
                        {
                            rblQ35.SelectedValue = sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID.ToString();
                        }
                        else
                        {
                            rblQ35.SelectedIndex = -1;
                        }
                        break;
                    case "36":
                        if (sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID > -1)
                        {
                            rblQ36.SelectedValue = sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID.ToString();
                        }
                        else
                        {
                            rblQ36.SelectedIndex = -1;
                        }
                        break;
                    case "37":
                        txtQ37.Text = sResult.RESULT_TEXT;
                        break;
                    case "38":
                        if (sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID > -1)
                        {
                            rblQ38.SelectedValue = sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID.ToString();
                        }
                        else
                        {
                            rblQ38.SelectedIndex = -1;
                        }
                        break;
                    case "39":
                        if (sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID > -1)
                        {
                            rblQ39.SelectedValue = sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID.ToString();
                        }
                        else
                        {
                            rblQ39.SelectedIndex = -1;
                        }
                        break;
                    case "40":
                        months = 0;
                        years = 0;
                        getYearsMonths(sResult.RESULT_TEXT, out years, out months);
                        txtQ40_1.Text = years.ToString();
                        txtQ40_2.Text = months.ToString();
                        break;
                    case "41":
                        if (sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID > -1)
                        {
                            rblQ41.SelectedValue = sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID.ToString();
                        }
                        else
                        {
                            rblQ41.SelectedIndex = -1;
                        }
                        break;
                    case "42":
                        if (sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID > -1)
                        {
                            rblQ42.SelectedValue = sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID.ToString();
                        }
                        else
                        {
                            rblQ42.SelectedIndex = -1;
                        }
                        break;
                    case "43":
                        months = 0;
                        years = 0;
                        getYearsMonths(sResult.RESULT_TEXT, out years, out months);
                        txtQ43_1.Text = years.ToString();
                        txtQ43_2.Text = months.ToString();
                        break;
                    case "44":
                        months = 0;
                        years = 0;
                        getYearsMonths(sResult.RESULT_TEXT, out years, out months);
                        txtQ44_1.Text = years.ToString();
                        txtQ44_2.Text = months.ToString();
                        break;
                    case "45":
                        if (sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID > -1)
                        {
                            rblQ45.SelectedValue = sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID.ToString();
                        }
                        else
                        {
                            rblQ45.SelectedIndex = -1;
                        }
                        break;

                    default:
                        break;
                }
            }
        }
        catch (Exception ex)
        {
            Exception _tbilogerror = HandleTBIException(ex, "PainOutcomes_Intake.aspx", "100027", "SetUpSurvey()");
        }
    }
    // END SetUpSurvey

    #endregion
}
